﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Text;

public partial class Admin_Template_PageTemplateList_Edit : System.Web.UI.Page
{
    private 访问 访问;
    protected int ID;
    protected String 模板类型;
    protected String 模板组;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("修改列表分页模板", "网站后台", "修改列表分页模板", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();
        ID = Convert.ToInt32(Request.QueryString["ID"]);
        模板类型 = Request.QueryString["type"];
        模板组 = Request.QueryString["group"];

        if (this.IsPostBack)
            修改列表分页模板();
        else
            初始化();
    }

    private void 初始化()
    {
        设置 设置 = new 设置(File.ReadAllText(Server.MapPath("~/Template/" + 模板类型 + "/" + 模板组 + "/Page/"+ID+".xml"), Encoding.UTF8));

        MoBanMingChen.Text = 设置["模板名称"].ToString();
        MoBanShuoMing.Text = 设置["模板说明"].ToString();
        DaiMaNeiRong.Text = 设置["代码内容"].ToString();
        _3GDaiMaNeiRong.Text = 设置["3G代码内容"].ToString();
    }

    private void 修改列表分页模板()
    {
        访问.验证权限("51");
        String 模板名称 = MoBanMingChen.Text;
        String 模板说明 = MoBanShuoMing.Text;
        String 代码内容 = DaiMaNeiRong.Text;
        String _3G代码内容 = _3GDaiMaNeiRong.Text;

        if (模板名称.Length < 1 || 模板名称.Length > 50)
            throw new Exception("模板名称的长度只能在1-50之间");
        if (模板说明.Length < 1 || 模板说明.Length > 200)
            throw new Exception("模板说明的长度只能在1-200之间");

        String 编译结果, _3G编译结果;
        列表分页代码 列表分页 = new 列表分页代码(代码内容, _3G代码内容);
        列表分页.生成代码(out 编译结果, out _3G编译结果);

        设置 设置 = new 设置(File.ReadAllText(Server.MapPath("~/Template/" + 模板类型 + "/" + 模板组 + "/Page/"+ID+".xml"), Encoding.UTF8));

        设置["模板名称"] = 模板名称;
        设置["模板说明"] = 模板说明;
        设置["代码内容"] = 代码内容;
        设置["3G代码内容"] = _3G代码内容;
        设置["编译结果"] = 编译结果;
        设置["3G编译结果"] = _3G编译结果;
        设置["方法库"] = 列表分页.方法库;
        设置["3G方法库"] = 列表分页._3G方法库;

        File.WriteAllText(Server.MapPath("~/Template/" + 模板类型 + "/" + 模板组 + "/Page/" + ID + ".xml"), 设置.生成XML(), Encoding.UTF8);

        Response.Redirect("PageTemplateList.aspx");
    }
}
